<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong, modified by Marjuqi R.
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      Comment
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Comment_Manage extends Controller_Space_Cms {
    protected $site;
    protected $items_per_page = 10;
    protected $total_items;
    public $comment;
    
    public function before() {
        parent::before();     
        $this->comment = Model::factory('comment');
        Paging::factory();
    }
    
    public function action_index() {        
        $this->list_data();   
    }

    public function action_list() {
        $this->list_data();
    }
    
    private function list_data() {

        $data = $this->comment->list_comments($this->items_per_page);
        
        $paging = Paging::factory(array(
                'model' => 'comment',
                'items_per_page' => $this->items_per_page,
                'list_items' => $data
            )); 
        
        Paging::$init->compile();       

        $this->site->menu->active = 'comment_list';
        $this->meta('title','Manage Comment List')
             ->set('title',__('comment list'))
             ->set('content',View::factory('cms/comment-list', array(
                    'site' => $this->site,
                    'paging'=>$paging
                )))
             ->render();    
        
    }
    
    public function action_create() { 
	
        if ($this->authorisation === true) {
            $title = __('create',array('%item'=>__('comment',array('%s'=>''))));
            
            $this->meta('title',__('manage_comment'))
                 ->set('title',$title)
                 ->set('content',View::factory('cms/comment-form', array(
                        'site' => $this->site,
                        'action' => 'create',
                        'page' => 'create'
                    )))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();    
        }
    }  
    
    public function action_save() {  
        if ($this->authorisation === true) {  
            if($this->post) {
                $transaction =  Transaction::factory(array(
                       'package' => 'comment',
                       'form'    => 'create_comment',
                       'job'     => 'insert',
                       'owner'   => $this->site->user->profile->id,
					   'post'    => $this->post
                  ));
                $transaction->start();
                $transaction->execute($transaction);
            }
        }
        
        $this->request->redirect('admin-cp/comment/manage');
    }
    
    public function action_edit() {
        if ($this->authorisation === true) {  
            $title = __('edit',array('%item'=>__('comment',array('%s'=>''))));
            
            $this->meta('title',__('manage_comment'))
                 ->set('title',$title)
                 ->set('content',View::factory('cms/comment-form',array(
                    'data' 	=> $this->comment->get_data($this->param1),
                    'page' 	=> 'update',
                    'action'=> 'update',
                    'site' 	=> $this->site
                 )))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }    
    
    public function action_update() {
        if ($this->authorisation === true) {  
            if($this->post) {               
                $transaction =  Transaction::factory(array(
                       'package' => 'comment',
                       'form'    => 'edit_comment',
                       'job'     => 'update',
                       'owner'   => $this->site->user->profile->id,
                       'item_id' => $this->param1,
					   'post'    => $this->post
                  ));
                $transaction->start();  
                $transaction->_object['comments']->where('id = '.$this->param1);
                $transaction->execute($transaction);
                
                if ($transaction === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }
        $this->request->redirect('admin-cp/comment/manage/edit/'.$this->param1);
    }
}
   

?>