<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Contact Category)
 * @Module      Contact Category
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_ContactCategory extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('label')->from('contact_categories')->where('id = '.$id)->execute()->current();
        return empty($check->label) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'contact_categories "'.$check->label.'"'
                ));
    }
        
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_contactcategory($execution = TRUE){
        $contact_categories = Setup::join_histories('contact_categories')
                    ->order_by('id','desc');                     
        return $execution === true ? $contact_categories->execution() : $contact_categories;
    }
   
    /**
     * @param mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('contact_categories');
        
        if ($get_params[0] == 'field') {
            $field_name = "contact_categories.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * get all categories and it's receiver email
     */
    public function get_all_active_category(){
        $result = DB::select()
                ->from('contact_categories')
                ->where('status', '=', 'active')
                ->as_object()
                ->execute();
        
        if($result->valid()){
            return $result;
        } else {
            return null;
        }
    }
}
?>