<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (News Category)
 * @Module      News 
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_NewsCategory extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('label')->from('news_categories')->where('id = '.$id)->execute()->current();
        return empty($check->label) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'news_category "'.$check->label.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_newscategory($execution = TRUE){
        $categories = Setup::join_histories('news_categories',array(array(DB::expr('COUNT(`ns`.`id`)'),'total_news')))
                        ->join(array('news','ns'))
                        ->on('ns.news_category_id = news_categories.id');     
                                        
        return $execution === true ? $categories->execute() : $categories;
    }
    
    /**
     * @param int   category id
     * @return int  total category news
     */
    public function total_news_in_category($category_id=0) {
        return $this->select(array(DB::expr('COUNT(`id`)'),'total'))
                    ->from('news')
                    ->where('news_category_id = '.$category_id)
                    ->execute()
                    ->current()
                    ->total;
    }
   
    /**
     * @param mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('news_categories');
        
        if ($get_params[0] == 'field') {
            $field_name = "news_categories.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
}
?>