<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Cms Class Controller
 * @Module      Order
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Order_Inquiry extends Controller_Space_Cms {
    protected $site;
    protected $model;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'iquiry_list';
        $this->authorized(array(
                //nama_module => action (separate by commas)
                'order' => 'create_inquiry,delete_inquiry,view_industry',
            )); // Check permission           
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }  
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('inquiry_logs.id = '.$value_condition)
            ->or_where('inquiry_logs.subject like %'.$value_condition.'%')
            ->or_where('inquiry_logs.message like %'.$value_condition.'%')
            ->or_where('inquiry_logs.status like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_manage();
    }
        
    public function action_manage() {    
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'inquiry',
                    'items_per_page' => 10
                ));
            $this->condition();
            Paging::$init->compile();
            
            $this->meta('title',__('manage_inquiry_logs'))
                 ->set('title',__('manage_inquiry_logs'))
                 ->set('content',$this->html('inquiry-list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
        
    }
    
}