<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Contact Category)
 * @Module      Contact Category
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Inquiry extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('label')->from('inquiry_logs')->where('id = '.$id)->execute()->current();
        return empty($check->label) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'inquiry_logs "'.$check->label.'"'
                ));
    }
        
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_inquiry($execution = FALSE){
        $inquiry_logs = Setup::join_histories_2('inquiry_logs')
                    ->order_by('id','desc');                     
        return $execution === true ? $inquiry_logs->execution() : $inquiry_logs;
    }
   
    /**
     * @param mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories_2('inquiry_logs');
        
        if ($get_params[0] == 'field') {
            $field_name = "inquiry_logs.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * 
     */
    public function get_inquiry($id=null){
        // update the reading status //
        DB::update('inquiry_logs')
            ->set(array('status'=>'read'))
            ->where('id', '=', $id)
            ->execute();
        
        // get the detail //
        $result = DB::select('inquiry_logs.id',
                'inquiry_logs.title', 'inquiry_logs.name', 'inquiry_logs.phone', 
                'inquiry_logs.fax', 'inquiry_logs.email', 
                'inquiry_logs.company', 'inquiry_logs.company', 
                'inquiry_logs.attention', 'inquiry_logs.message', 'inquiry_logs.status',
                array('countries.title','country'),array('industries.title','industry')
                )
            ->from('inquiry_logs')
            ->where('inquiry_logs.id', '=', $id)
            ->join('countries', 'left')
            ->on('inquiry_logs.country', '=', 'countries.country_code')
            ->join('industries', 'left')
            ->on('inquiry_logs.industry', '=', 'industries.industry_code')
            ->as_object()
            ->execute();
        
        // return the detail //
        return ($result->valid()) ? $result : NULL;
    }
    
    /*
     * get all categories and it's receiver email
     */
    public function get_all_inqury($status=null, $id=null){
        $query = DB::select()
                ->from('inquiry_logs');
        
        if(!empty($status)){
            if(!empty($id)){
                $result = $query
                ->where('status', '=', $status)
                ->and_where('id', '=', $id)
                ->as_object()
                ->execute();
            } else {
                $result = $query
                ->where('status', '=', $status)
                ->as_object()
                ->execute();
            }
        } else {
            if(!empty($id)){
                $result = $query
                ->where('id', '=', $id)
                ->as_object()
                ->execute();
            } else {
                $result = $query
                ->as_object()
                ->execute();
            }
            
        }
        
        
        if($result->valid()){
            return $result;
        } else {
            return null;
        }
    }
}
?>