<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Helper
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Helper_Tool {
    /**
     * @var helper tool instance
     */
    private static $instance;
    
    /**
     * @var search value
     */
    public $search_value;
    
    public static function factory() {
        if (!isset(self::$instance)):
            self::$instance = new Helper_Tool;
        endif;
        return self::$instance;
    }
        
    public static function excerpt($text,$length,$continu = ' ...') {
        $itext  = substr($text,0,$length);
        $iarray = str_split($text);
        
        return count($iarray) > $length ? $itext.$continu : $text;
    }
    
    public static function vardump($data = null) {
        if (is_array($data)) return self::debug($data);        
        
        var_dump($data);
    }
    
    public static function debug(array $arr = array()) {
        return '<pre>'.print_r($arr,true).'</pre>';    
    }
    
    public static function arr_to_object($arr = NULL, $all = TRUE) {        
        if(!is_array($arr)):
            return $arr;
        endif;
        
        $object = new stdClass();
        
        foreach ($arr as $k=>$v):
            $k = strtolower(trim($k));
            if (!empty($k)):
                if ($all):
                    $object->$k = self::arr_to_object($v);
                else:
                    $object->$k = $v;
                endif;
            endif;
        endforeach;
        return $object;
    }
    
    public static function file_type($file = NULL,$dot_preceding = false,$separator = '.') {
        $dot_ext = strrchr($file,$separator);
        
        return $dot_preceding === true ? $dot_ext : substr($dot_ext,1);
    }
    
    public static function file_name($file = NULL,$separator = '.') {
        return str_replace(self::file_type($file,true,$separator),'',$file);
    }
    
    public static function file_name_beautification($file,$beautyfier='-') {
        $file_name = helper_tool::pretty_name(helper_tool::file_name($file),$beautyfier);
        $file_ext  = helper_tool::file_type($file);
        
        return $file_name.'.'.$file_ext;
    }
    
    public static function pretty_name($string='default',$replace_w = '-') {
        $regex = strtolower(preg_replace("/[^A-Za-z0-9+]/", $replace_w, trim($string)));
        $pattern = '/-{2,}/';
        $replace = '-';
        return preg_replace("/[$replace_w]+/","$replace_w",preg_replace($pattern, $replace, $regex));
    }
    
    public static function random_salt() {
        $pattern      = array ('9'=>'1','6'=>'2','3'=>'2','2'=>'2');
        $session_id   = Session::instance()->id();
        $random_salt  = '';
        foreach ($pattern as $start=>$length) {
            $random_salt .= substr($session_id,$start,$length);
        }
        
        return $random_salt;
    }
    
    public static function operator($id) {
        $operators = array('>=','>','<=','<','!=','=','<>');
        foreach ($operators as $operator) {
            if (strpos($id,$operator) !== false) {
                return $operator.' '.str_replace($operator,'',$id);
            }
        }
        return '= '.$id;
    }
    
    public static function manipulate_date($date) {
        return $date;    
    }
    
    public static function mixed_search($string=null){
        return  preg_replace("/".self::$instance->search_value."/i", "<span class=\"search_value\">\$0</span>", $string);
    }
}

?>