<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    History Mapping Class
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Historymap extends Setup {
    /**
     * @var text history description
     */
    public $description;
    
    /**
     * @var object model to mapping with history
     */
    protected $model;
    
    /**
     * @var string history object
     */
    protected $object;
    
    /**
     * @var string history item
     */
    protected $item;
    
    /**
     * @var array configuration
     */
    protected $config = array (
            'table'  => null,
            'action' => null,
            'actor'  => null,
            'to_map' => null,
            'quote'  => true, // Adding quote to History->item
        );
    
    public static function trim_table_name($table) {
        return 
            substr($table,-3) == 'ies' 
                ? substr($table,0,-3).'y' 
                : (substr($table,-1) == 's' ? substr($table,0,-1) : $table);
    }
    public static function factory(array $config = array()) {
        return new Historymap($config);
    } 
    
    public function __construct($config) {
        $this->set($config); 
        if (empty($this->table)) { return 'Not Set'; }        
        $this->define_model($this->table);
    }
    
    
    protected function define_model($table) {
        $model = Historymap::trim_table_name($table);        
        $model = $this->model_map($model);
        
        return Kohana::find_file('classes/model/',$model)
            ? $this->object_map($model)
            : $this->exception_map($model);  
    }
    
    protected function exception_map($model) {        
        $this->item = $model;    
        $action = "historymap_$model";
        $this->quote = false;        
        switch ($model) {
            case "modulemenu":
            case "modulemenupermission":
            case "modulemenuposition":
                $this->item = Model::factory('module')->$action($this->to_map);  
                break;
            case "userrolepermission":
            case "permission":
                $this->item = Model::factory('role')->$action($this->to_map,$this->action);  
                break;
            case "userdetail":
                $this->item = Model::factory('user')->historymap($this->to_map,'update_profile');
                break;
            default:
                $this->item = $this->no_model_action_found($this->action);
                break;
        }
        $this->action = '';    
        return $this->result_map(); 
    }
    
    protected function no_model_action_found($action) {
        $action .= ' '.$this->table.' '.$this->to_map;
        return $action;
    }
    
    protected function model_map($model) {
        return str_replace('_','',$model);
    }
    
    protected function object_map($model) {
        $model = Model::factory($model);
        if (method_exists($model,'historymap')) {
            $this->item   = $model->historymap($this->to_map,$this->action);
            $this->action = '';        
            $this->object = '';
            $this->result_map();
        }        
    }
    
    protected function result_map() {
        
        $this->description  = '<span class="history_actor">'.$this->actor.'</span> ';
        $this->description .= '<span class="history_action">'.$this->action.'</span> ';
        $this->description .= '<span class="history_object">'.$this->object.'</span> ';
        $this->description .= '<span class="history_item">'.$this->item.'</span>';
    }
    
    public function __toString() {
        return $this->description;
    }
}