<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Kohana Paging Class
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors
 * 	
**/ 


class Kohana_Paging { 
    /**
     * @var object paging
     */
    public static $init;
    
    /**
     * @var object kohana pagination result
     */
    public static $page;
    
    /**
     * @var array   Kohana Paging Class Configuration
     */
    public $configs = array (
                'items_per_page' => 0,
                'total_items' => 0,
                'model' => 'string',
                'count_field' => 'id',
                'view' => 'webarq',
                'list_items' => 'string',
            );
    
    /**
     * Instantiate Paging Class
     */
    public static function factory(array $configs = array()) {
        return new Paging($configs);
    }
    
    /**
     * @var mixed string configuration group name or array config
     */
    public function __construct(array $configs = array()){
        self::$init = $this;
        self::$page = new stdClass();
        self::$page->offset = 0;         // Default Offset
        self::$page->items_per_page = 0; // Default Perpage
              
        
        foreach (array_merge($this->configs,$configs) as $key => $config) {
            $this->magic($key,$config); // Setup Paging Class    
        }
        
        $this->check_model(false);         
    } 
    
    protected function magic($key = null , $value = null) {
                        
        if (isset($key) && isset($value)) {
            if ($key == 'model') {
                $model = "model_".strtolower($value);
                self::$init->$model = Kohana::find_file('classes/model/',$value)
                    ? Model::factory($value)
                    : null;                
                self::$init->model_active = $model;
            }
          
            self::$init->$key = $value;
        }
    }  
    
    protected function check_model($execution=true) {
        if (!empty(self::$init->model)) {
            $model = 'model_'.$this->model;
            $model = $this->$model;
            
            // Check if model have method to get data
            $method_limit = 'limit_'.$this->model;
            if (method_exists($model,$method_limit)) {
                self::$init->list_items = $model->$method_limit($execution);
            }
        }
    }
    
    /**
     * @param   string query data before added limit, offset option
     */
    public function total_record($query = null) {
        $query = empty($query) ? $this->list_items->__print() : $query;
        $query_total = "SELECT COUNT(`id`) `total` FROM (".$query.")`xtotal`";        
        return $this->total_items = DB::query(Database::SELECT,$query_total)->as_object()->execute()->current()->total;
    }
    /**
     * Compile paging, and bond again to Kohana Pagination
     */
    public function compile() {
        $this->total_record();
                                       
        self::$page = Pagination::factory(array(
                    'items_per_page' => $this->items_per_page,
                    'total_items' => $this->total_items,
                    'view' => 'pagination/'.$this->view,
                    'url' => 'dsds',                                        
                ));  
        
        self::$init->list_items = $this->list_items
                                       ->offset(self::$page->offset)
                                       ->limit(self::$page->items_per_page)
                                       ->execute();
    }
}