<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Class Traversal
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors
**/ 

class Traversal {    
    
    public $general_configs = array (
            'table'             => null,
            'fields'            => array(),
            'array_data'        => null,
            'start_value'       => 0,
            'condition_fields'  => array('parent_id','id'),
            'extend_conditions' => array (
                    //array("where","field_1 = value_1")
                    //array("where","field_1","=","value_1")
                    //array("or_where","field_1 = value_1")
                    //array("or_where","field_1","=","value_1")
                )
        );
        
    // Object SQL Query
    public static $object_query;
    
    // String target table operation 
    protected $table;
    
    // Fields of transaction query
    protected $fields = array();
    
    // Array data
    protected $array_data = array();
    
    // Start traverse value
    protected $start_value;
    
    // Traversing conditional field (where field,next value field)
    protected $condition_fields;
    
    // Array conditions query fields
    protected $extend_conditions;
    
    // Traversing html return;
    public $html_return = '';
    
    // String traverse type, originally created by class;
    protected $traverse_type;
    
    /**
     * array config (
     *  'field_opt_value'   => 'field name for option value'(string),
     *  'field_opt_text'    => 'field name for option text'(string),
     *  'group'             => 'status of option group'(boolean) // On going,
     *  'attributes'        => array select attributes,
     * )
     */
    public static function select(array $config=array()) {
        $config['traverse_type'] = 'select';
        $config['fields'] = array($config['field_opt_value'],$config['field_opt_text']);
        return new Traversal($config);
    }
    
    /**
     * array config (
     *  'columns'          => 'Array table column',
     *  'listing_template' => 'view table template name',
     *  'tr_template'      => 'view tr template name',
     *  'attributes'       => 'table attributes'
     * )
     * 
     */
    public static function traversing_table(array $config=array()) {        
        if(empty($config['listing_template'])) 
            $config['listing_template'] = 'html/plug/traversing-listing-template';
            
        $config['traverse_type'] = 'table';
        return new Traversal($config);
    }
    
    /**
     * array config (
     *  'class' => 'string class name',
     *  'id'    => 'string id name',
     *  'attr'  => 'array attributes'
     * )
     * 
     * return traversing ul
     */
    public static function traversing_ul(array $config=null) {
        $config['traverse_type'] = 'ul';
        return new Traversal($config);    
    }
    
    public function __construct($config) {
        $config = array_merge($this->general_configs,$config);
        foreach ($config as $item => $value)
            $this->$item = $value;
            
        $this->check($status);
        
        if ($status === true) {
            $this->array_data = empty($this->array_data)
                ? $this->traversing_data($this->start_value)
                : $this->array_data;
        }                 
        
        $do_method = 'do_'.$this->traverse_type;
        if (method_exists($this,$do_method))
            $this->$do_method();
        else
            $this->html_return = __('method_not_found',array(
                        '%method_name' => $do_method,
                        '%class_name'  => "Traversal"
                    ));
    }
    
    // Setup  
    protected function check(&$return) {
        $return = true;
        if (empty($this->table) && empty($this->array_data)) {
            $return = false; $this->html_return = 'Error. Please check your traversing table name'; 
        }
    }
    
    /**
     * Prepare array data if still empty
     */
    public function traversing_data($value=null,$level = 0) {
        $get = Model::factory('base')
                ->select_array($this->fields)
                ->from($this->table)
                ->where($this->condition_fields[0].' = '.$value);
        
        if (!empty($this->extend_conditions) && is_array($this->extend_conditions)) {
            foreach ($this->extend_conditions as $item) {
                if (is_array($item)) {
                    $count = count($item);
                    if ($count == 1)    $get->$item[0]();
                    elseif($count == 2) $get->$item[0]($item[1]);
                    elseif($count == 3) $get->$item[0]($item[1],$item[2]);
                    elseif($count == 4) $get->$item[0]($item[1],$item[2],$item[3]);    
                    elseif($count == 5) $get->$item[0]($item[1],$item[2],$item[3],$item[4]);    
                    elseif($count == 6) $get->$item[0]($item[1],$item[2],$item[3],$item[4],$item[5]);
                }
            }
        } 
        
        $get = $get->execute();
        
        if (!empty($get[0])) {
            $index_data = 0;
            
            foreach ($get as $item) {
                
                $result[$index_data]['level'] = $level;
                
                if (empty($this->field)) 
                    $result[$index_data]['data'] = $item;
                elseif (is_array($this->field)) {
                    foreach ($this->field as $field)
                        $result[$index_data]['data'][$field] = 
                            empty($item->$field) ? null : $item->$field;
                }
                
                $next_checking_value = $this->condition_fields[1];
                $result[$index_data]['child'] = $this->traversing_data($item->$next_checking_value,$level+1);
                $index_data++;
            }   
        } else {
            return null;
        }
        
        return $result;    
    } 
    
    protected function do_select() {
        $value = '';
        if (isset($this->attributes['value'])) {
            $value = $this->attributes['value'];
            unset($this->attributes['value']);     
        }
        
        
        $this->html_return  = '<select '.HTML::attributes($this->attributes).'>';
        $this->html_return .= $this->traverse_option($this->array_data,$value);
        $this->html_return .= '</select>';
    }   
    
    protected function traverse_option($data,$value=0,$level=0) {
        $option = $level == 0 ? '<option value="0">'.__('this_is_a_parent').'</option>' : '';
        if (!empty($data) && is_array($data)) {
            foreach ($data as $item) {
                extract($item,EXTR_PREFIX_ALL,'item');
                
                $option .= '<option ';
                $option .= 'level ="'.$item_level.'" ';
                
                // Check for option value and text
                $field_opt_value = $this->field_opt_value;
                $field_opt_text  = $this->field_opt_text;
                
                if (isset($item_data)) {
                    if (is_array($item_data)) {
                        $current_value = isset($item_data[$field_opt_value]) 
                                    ? $item_data[$field_opt_value]
                                    : 'Error :(';
                        $current_text  = isset($item_data[$field_opt_text]) 
                                    ? $item_data[$field_opt_text]
                                    : 'Error :(';
                    } elseif(is_object($item_data)) {
                        $current_value = isset($item_data->$field_opt_value) 
                                    ? $item_data->$field_opt_value
                                    : 'Error :(';
                        $current_text  = isset($item_data->$field_opt_text) 
                                    ? $item_data->$field_opt_text
                                    : 'Error :(';
                    }
                }                    
                
                $option .= 'value ="'.$current_value.'" ';
                $option .= $value == $current_value ? 'selected="selected" ' : '';
                    
                $option .= '>';
                
                for ($i = 0; $i < $item_level; $i++)
                    $option .= $i == 0 ? "--" : "&nbsp;--";
                $option .= $item_level > 0 ? '&nbsp;&nbsp;' : '';
                
                $option .= $current_text;
                $option .= '</option>';
                    
                if (!empty($item_child) && is_array($item_child)) {
                    $option .= $this->traverse_option($item_child,$value,$level+1);
                }
            }                        
        }
        
        return $option;
    }
    
    public function do_table() {
        $this->html_return = View::factory($this->listing_template,array(
                'columns'    => $this->columns,
                'tbody'      => $this->tbody($this->array_data),
                'paging'     => empty($this->paging) ? '' : $this->paging,
                'site'       => Config::$site_config
            ))->render();    
        Session::instance()->delete('traversing_item');
    }
    
    /**
     * array config (
     * 'array_data' => 
     * )
     */
    public function tbody($data,$number_row=0,$parent_node=0) {
        $option = '';
        $view   = empty($this->listing_template_body) 
                    ? $this->listing_template.'-tbody' 
                    : $this->listing_template_body;
                    
        if (!empty($data) && is_array($data)) {
            $index_data   = empty($this->paging) 
                                ? 1 
                                : $this->paging->current_first_item;
            
            foreach ($data as $item) {
                extract($item,EXTR_PREFIX_ALL,'item');
                                                
                $index_node = Session::instance()->get('traversing_item',0);                
                $index_node = $index_node+1;                
                Session::instance()->set('traversing_item',$index_node);
                
                $number_node = empty($number_row) ? $index_data : '&nbsp;'.$number_row.'.'.$index_data;                
                
                if (isset($item_data)) {
                    $option .= View::factory($view,array(
                            'item'       => $item_data,
                            'total_item' => count($data),
                            'columns'    => $this->columns,
                            
                            'index_row'  => $number_node,                            
                            'index_item' => $index_data,
                            'index_node' => $index_node,
                            'parent_node'=> $parent_node,
                            
                            'level'      => $item_level,
                            'site'       => Config::$site_config,
                            'as_parent'  => !empty($item_child) && is_array($item_child) ? true : false
                        ));
                    
                    // Item Child
                    if (!empty($item_child) && is_array($item_child)) {
                        $option .= $this->tbody($item_child,$number_node,$index_node);
                    }
                
                    $index_data++;
                }
            }
            
        }
        
        return $option;
    }
    
    public function do_ul() {
        
        
    } 
    
    public function to_string() {
        return $this->html_return;
    }
    
    public function __toString() {
        return $this->to_string();
    }
}

?>