<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Industry List
 * @Module      Order
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

?>

<style>
#fade { /*--Transparent background layer--*/
    display: none; /*--hidden by default--*/
    background: #000;
    position: fixed; left: 0; top: 0;
    width: 100%; height: 100%;
    opacity: .80;
    z-index: 9999;
}
.popup_block{
	display: none; /*--hidden by default--*/
	background: #fff;
	padding: 20px;
	border: 10px solid #ddd;
	float: left;
	font-size: 1.2em;
	position: fixed;
	top: 50%; left: 50%;
	z-index: 99999;
	/*--CSS3 Box Shadows--*/
	-webkit-box-shadow: 0px 0px 20px #000;
	-moz-box-shadow: 0px 0px 20px #000;
	box-shadow: 0px 0px 20px #000;
	/*--CSS3 Rounded Corners--*/
	-webkit-border-radius: 10px;
	-moz-border-radius: 10px;
	border-radius: 10px;
}
img.btn_close {
	float: right;
	margin: -55px -55px 0 0;
}
/*--Making IE6 Understand Fixed Positioning--*/
*html #fade {
	position: absolute;
}
*html .popup_block {
	position: absolute;
}
    
</style>

<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'product/accessory/manage/list/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'product/accessory/form/create'); ?></div>    
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="no"><?php echo __('no');?></th>
            <th class="title"><?php echo __('Title');?></th>
            <th class="title"><?php echo __('Product Category');?></th>
            <th class="title"><?php echo __('Product Item');?></th>
            <th class="addres"><?php echo __('Pdf');?></th>
            <th class="addres"><?php echo __('Image');?></th>
            <th class="status"><?php echo __('status');?></th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $item) {
                                        
                    $modify_class = __make_class($index,$item->status);
                    
                    echo '<tr class="'.$modify_class.'">',"\n";
//                        echo '<td class="checkbox">';       
//                            echo Form::checkbox('','',false,array(
//                                    'class' => 'tocheck',
//                                    'idx' => $item->id
//                                ));   
//                        echo '</td>';
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$item->title.'</td>';
                        
                        $product_category = Model::factory('product')->get_category_name($item->product_category_id);  
                        $product_item = Model::factory('product')->get_item_name($item->product_item_id); 
                        echo '<td>'.$product_category.'</td>';
                        echo '<td>'.$product_item.'</td>';
                        
                        echo '<td class="center">';
                        echo (!empty($item->file_path))?HTML::anchor(URL::base(true).$item->file_path, HTML::image(Config::$site_config->themes_img.'cms/icon/pdf.png')):'';
                        echo '</td>';
                        echo '<td class="center">';
                        echo (!empty($item->image_path))
                                ? '<a href="#?w=180" class="poplight image_view" rel="popup_name" accessory_id="'.$item->id.'">'.
                                    HTML::image(Config::$site_config->themes_img.'cms/icon/photo.png').'</a>'
                                : '';
                        echo '</td>';
                        echo '<td class="center">'.$item->status.'</td>';
                        echo '<td class="center">';
                            $list_action  = $item->status == 'active' ? 'deactivate' : 'activate';
                            $update_value = $item->status == 'active' ? 'inactive' : 'active';
                              
                            echo Form::list_action($site,$list_action,array(   
                                    "class"  => "ajax",
                                    "href"   => $site->bs_cms.'system/ajax/update-status/product_accessories/'.$update_value.'/'.$item->id,
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>$list_action,'%data'=>__('accessory').' '.$item->title)).'"
                                                    }]
                                        }',
                                ));
                            echo '&nbsp; &nbsp;';
                            
                            echo Form::list_action($site,'edit',array(   
                                    'title' => __('edit_user'),
                                    'href'  => $site->bs_cms.'product/accessory/form/edit/'.$item->id
                                ));
                            echo '&nbsp; &nbsp;';
                                                      
                            echo Form::list_action($site,'delete',array(   
                                    'title' => __('delete_role'),
                                    "href"   => $site->bs_cms.'product/ajax/delete-accessory/'.$item->id,
                                    'class' => 'ajax',
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('industy'.' '.$item->title))).'"
                                                    }]
                                        }',
                                ));
                                echo '&nbsp; &nbsp;';
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="9">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="8">
                <?php 
                echo '&nbsp;';
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>

<div id="popup_name" class="popup_block">
    <div id="container_image" style="padding: 0px 25px 25px 25px;">
        <id id="accessory_image" style="text-align: center;"></id>
    </div>
</div>

<script>
    $(function(){
        $(".image_view").click(function(){
            var accessory_id = $(this).attr('accessory_id')
            
            $.ajax({
            url: bs_cms + 'product/ajax/view-accessory-image',
            type: "post",
            data: "accessory_id="+accessory_id,
            async: false,
            dataType : 'json',
            success: function(msg) {
                image = msg.image_path;  
                $("#accessory_image").html('');                 
                $("#accessory_image").append("<span><img src='"+bs_site+'imagefly/w120-h95-c/'+image+"'></span>");                 
                } 
            });
         });

        $(".image_view").colorbox({inline:true, width:"880px"});
    });
</script>

<script>
$(document).ready(function() {
//When you click on a link with class of poplight and the href starts with a # 
$('a.poplight[href^=#]').click(function() {
    var popID = $(this).attr('rel'); //Get Popup Name
    var popURL = $(this).attr('href'); //Get Popup href to define size

    //Pull Query & Variables from href URL
    var query= popURL.split('?');
    var dim= query[1].split('&');
    var popWidth = dim[0].split('=')[1]; //Gets the first query string value

    //Fade in the Popup and add close button
    $('#' + popID).fadeIn().css({ 'width': Number( popWidth ) }).prepend('<a href="#" class="close">&nbsp;</a>');

    //Define margin for center alignment (vertical   horizontal) - we add 80px to the height/width to accomodate for the padding  and border width defined in the css
    var popMargTop = ($('#' + popID).height() + 80) / 2;
    var popMargLeft = ($('#' + popID).width() + 80) / 2;

    //Apply Margin to Popup
    $('#' + popID).css({
        'margin-top' : -popMargTop,
        'margin-left' : -popMargLeft
    });

    //Fade in Background
    $('body').append('<div id="fade"></div>'); //Add the fade layer to bottom of the body tag.
    $('#fade').css({'filter' : 'alpha(opacity=80)'}).fadeIn(); //Fade in the fade layer - .css({'filter' : 'alpha(opacity=80)'}) is used to fix the IE Bug on fading transparencies 

    return false;
});

//Close Popups and Fade Layer
$('a.close, #fade').live('click', function() { //When clicking on the close or fade layer...
    $('#fade , .popup_block').fadeOut(function() {
    	    $('#fade, a.close').remove();  //fade them both out
});
return false;
});
});
</script>