<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Api Class (User)
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Kohana_User {
    /**
     * @var object user object
     */
    public static $init;
    
    /**
     * @var array   Kohana User Class Configuration
     */
    public $config = array (
                'hash' => 'ripemd160',
                'loginbyemail' => true,
                'avatar_folder' => 'media/images/avatars/',
                'avatar_thumb' => array('41x41','120x145'),
                'limit' => 20
            );        
    
    /**
     * @var object  Current user profile
     */
    public $profile;
    
    /**
     * @var mixed string configuration group name or array config
     */
    public static function factory($configs = NULL) {
        return self::$init = new User($configs);    
    }
    
    /**
     * @var mixed string configuration group name or array config
     */
    public function __construct($configs = NULL){
        Package::$init->populate($this,$configs);
        $this->setup_profile_directory_thumb();        
        $this->profile = new stdClass();
        $this->model_role = Model::factory('role');
    }
    
    protected function setup_profile_directory_thumb() {
        foreach ($this->avatar_thumb as $dir_name) {
            if(!is_dir($this->avatar_folder.$dir_name))
                mkdir($this->avatar_folder.$dir_name,0755);            
        }
    }
    
    public function make_password($string) {
        return hash($this->config['hash'],$string); 
    }
    
    /**
     * @var string session id
     */
    public function identify($session) {
        $this->setup_profile($this->model_user->get_by('session',$session));
    }    
    
    /**
     * @var string username
     * @var string passsword
     */    
    public function login($username,$password,$session,$type = 'admin') {
        $this->setup_profile($this->model_user->get_by('login',$username,$this->make_password($password)));    
        if (!empty($this->profile->is_login)) {
            if ($type == 'admin' && $this->profile->is_admin != 1) return null;
            Cookie::set('cms',$session);
            $this->model_user->insert('user_sessions')
                ->set('user_id',$this->profile->id)
                ->set('session',$session)
                ->set('login',date('Y-m-d H:i:s'))
                ->execute();
        }
    }
    
    protected function setup_profile($profile) {
        if (!empty($profile[0])){
            $this->profile = $profile[0];
            $this->profile->is_login =  true;
            $permissions = $this->model_role->mapping_role_permissions($this->profile->role_id);
            if (!empty($permissions[0]))
                $this->set_permission($permissions);
        }
        return $this->profile;
    }
    
    public function logout($session) {
        $this->profile = NULL;
        return $this->model_user->update('user_sessions')
                    ->set('logout',date('Y-m-d H:i:s'))
                    ->where("session = $session")
                    ->execute();
    } 
    
    /**
     * @param   mixed   int id user or string field name
     * @param   string  field value
     * @uses    User::$init->get(2) or User::$init->get('name','John Doe');
     */
    public function get($field,$value = NULL) {
        if (is_int($field)) {
            $value = $field;
            $field = 'id';
        }
           
        $user = $this->model_user->get_by('field',$field,$value);
        $user = empty($user[0]) ? new stdClass() : $user[0];
        
        if (empty($user->id)) {
            $config_package = Kohana::$config->load('package/user');
            if (!empty($config_package->configuration)) {                
                foreach (json_decode($config_package->configuration) as $table=>$fields) {
                    foreach($fields as $name=>$attr) {
                        if ($name != 'password')
                            $user->$name = 'Not Found';
                    }
                }
            }
        }
        return $user;           
    }
    
    // All Permission Handler
    protected function set_permission($permissions){
        $this->profile->permission = new stdClass();
        $module_active = '';
        $permit_string = null;
        foreach ($permissions as $permission) {
            $permit_string .= empty($permit_string) ? $permission->id : ','.$permission->id;
            if ($module_active != $permission->module_id) {
                $permit_module = $permission->module_id;
                
                // Set as new class if empty
                if (empty($this->profile->permission->$permit_module))
                    $this->profile->permission->$permit_module = new stdClass();
            }
            $permit_action = $permission->action;
            $this->profile->permission->$permit_module->$permit_action = $permission->id;
            $module_active = $permission->module_id;
        }
        $this->profile->permission->string = $permit_string;
    }
    
    /**
     * @param mixed function params
     */
    public function is_accessible($id_menu = null) {
        if (empty($id_menu)) return false;
        $params = func_get_args();        
        if (empty($params[0])) return false;
        $next_function = "is_accessible_".$params[0];
        
        switch ($params[0]) {
            case "module_menu":
                return $this->$next_function($params[1]);
                break;
        }        
    }
    
    protected function is_accessible_module_menu($id) {
        $get_menu = $this->model_user->select('mmp.id')->from(array('module_menu_permissions','mmp'))
            ->join(array('user_role_permissions','urp'))->on("urp.permission_id = mmp.permission_id")
            ->where("mmp.module_menu_id = $id")
            ->and_where("urp.role_id = ".$this->profile->role_id)
            ->execute();
            
        return empty($get_menu[0]) ? false : true;
    }
    
    
    public function form_select_role(array $attributes = array()) {
        extract($attributes);
        $cookie = Cookie::get('cms','absolutely_empty');
        $this->identify($cookie);
        if ( !empty($this->profile->id) && $this->profile->is_admin == 1) {
        
            $roles = array(''=>__('select_one'));
            $obj_role = Model::factory('role')->get_role(false)
                ->where('r.status = active')
                ->and_where('r.id >= '.$this->profile->role_id)
                ->execute();
            if (!empty($obj_role)) {            
                foreach ($obj_role as $role) {
                    $roles[$role->id] = __($role->label);    
                }
            }
            
            $attribute = $this->tool->arr_to_object($attributes,false);
            return Form::select($attribute->name,$roles,$attribute->value,$attribute->attribute);
            
        }
    }
    
}